<%--
 This is an error page delivered by the TaskInterface servlet when the user
 appears to have interacted with a page in the browser's history, but we can't
 figure out what task is affected.  Its job is to display a brief warning
 message instructing them not to do that, then redirect the browser to a URL
 that will show the current panel for that task, using the window's name as the
 key.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.tasks.res.task">
<html>
<head>
   <hmc:title><fmt:message key="historyWarningTitle"/></hmc:title>
   <link href="/wclres/WclBaseSkinCSS.css" rel="stylesheet" type="text/css"/>
   <link rel="SHORTCUT ICON" href="/favicon.ico"/>
   <link rel="icon" href="/hmc.png" type="image/png"/>
</head>
<body>
<span class="wclContainer">
<h1><fmt:message key="historyWarningTitle"/></h1>
<p><fmt:message key="historyWarningMessage"/></p>
</span>

<script type="text/javascript">
   function updatePanel() {
      if (window.name == "") {
         document.writeln("<fmt:message key='unknownWindowMessage'/>");
         document.close();

      } else {
         window.location.replace("/hmc/content?windowName="+window.name);
      }
   }

   // Make sure the message can be read
   window.resizeTo(<fmt:message key="historyWindowWidth"/>,
                   <fmt:message key="historyWindowHeight"/>);

   window.setTimeout("updatePanel()", 4000);
</script>
</body>
</html>
</fmt:bundle>
